<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WP_Bootstrap_4
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="http://gmpg.org/xfn/11">

    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

    <div class="loader-wrapper">
        <div class="loader">
            <div class="image">
                <i class="fa fa-codepen"></i>
            </div>
            <span class="percentage" id="precent"></span>
        </div>
    </div>



	<div id="page" class="site ">
        <header id="masthead" class="site-header <?php if ( get_theme_mod( 'sticky_header', 0 ) ) : echo 'sticky-top'; endif; ?>">
            <div class="menu-left">
                <a href="" id="download-report">DESCARGAR INFORME 2018</a>
                <ul class="main-menu menu-desk">
                    <li>
                        <a href="#generales" class="scroll menu-generales">Generales</a>
                    </li>
                    <li>
                        <a href="#agua" class="scroll menu-agua">Agua</a>
                    </li>
                    <li>
                        <a href="#primera-infancia" class="scroll menu-primera-infancia">Primera Infancia</a>
                    </li>
                    <li>
                        <a href="#programa-cultural-femsa" class="scroll menu-programa-cultural-femsa">Programa Cultural FEMSA</a>
                    </li>
                </ul>
                <div class="menu-tablet">
                    <ul class="main-menu">
                        <li>
                            <a href="#generales" class="scroll menu-generales">Generales</a>
                        </li>
                        <li>
                            <a href="#agua" class="scroll menu-agua">Agua</a>
                        </li>
                        <li>
                            <a href="#primera-infancia" class="scroll menu-primera-infancia">Primera Infancia</a>
                        </li>
                        <li>
                            <a href="#programa-cultural-femsa" class="scroll menu-programa-cultural-femsa">Programa Cultural FEMSA</a>
                        </li>
                        <li>
                            <a href="#centros-academicos" class="scroll menu-centros-academicos">Centros académicos</a>
                        </li>
                        <li>
                            <a href="#foros-y-espacios" class="scroll menu-foros-y-espacios">Foros y espacios</a>
                        </li>
                        <li>
                            <a href="#agradecimientos" class="scroll menu-agradecimientos">Agradecimientos</a>
                        </li>
                    </ul>
                    <div class="redes-wrapper">
                        <div class="social">
                            <?php echo do_shortcode( '[cn-social-icon]' ); ?>
                        </div>
                        <ul class="lang">
                            <li>
                                <a href="" class="active">ES</a>
                            </li>
                            /
                            <li>
                                <a href="">EN</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="menu-center">
                <?php the_custom_logo(); ?>
            </div>
            <div class="menu-right">
                <div class="block">
                    <ul class="main-menu">
                        <li>
                            <a href="#centros-academicos" class="scroll menu-centros-academicos">Centros académicos</a>
                        </li>
                        <li>
                            <a href="#foros-y-espacios" class="scroll menu-foros-y-espacios">Foros y espacios</a>
                        </li>
                        <li>
                            <a href="#agradecimientos" class="scroll menu-agradecimientos">Agradecimientos</a>
                        </li>
                    </ul>
                    <div class="redes-wrapper">
                        <div class="social">
                            <?php echo do_shortcode( '[cn-social-icon]' ); ?>
                        </div>
                        <ul class="lang">
                            <li>
                                <a href="" class="active">ES</a>
                            </li>
                            /
                            <li>
                                <a href="">EN</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <img src="<?php echo site_url(); ?>/wp-content/uploads/2019/03/logo-mobile.png" class="logo-mobile">
            <div class="button_container mobile-menu-button" id="toggle">
                <span class="top"></span>
                <span class="middle"></span>
                <span class="bottom"></span>
            </div>
            <div class="mobile-menu">
                <div class="redes-wrapper">
                    <div class="social">
                        <?php echo do_shortcode( '[cn-social-icon]' ); ?>
                    </div>
                    <ul class="lang">
                        <li>
                            <a href="" class="active">ES</a>
                        </li>
                        /
                        <li>
                            <a href="">EN</a>
                        </li>
                    </ul>
                </div>
                <ul class="main-menu">
                    <li>
                        <a href="#generales" class="scroll menu-generales">Generales</a>
                    </li>
                    <li>
                        <a href="#agua" class="scroll menu-agua">Agua</a>
                    </li>
                    <li>
                        <a href="#primera-infancia" class="scroll menu-primera-infancia">Primera Infancia</a>
                    </li>
                    <li>
                        <a href="#programa-cultural-femsa" class="scroll menu-programa-cultural-femsa">Programa Cultural FEMSA</a>
                    </li>
                    <li>
                        <a href="#centros-academicos" class="scroll menu-centros-academicos">Centros académicos</a>
                    </li>
                    <li>
                        <a href="#foros-y-espacios" class="scroll menu-foros-y-espacios">Foros y espacios</a>
                    </li>
                    <li class="sub">
                        <a href="#transferimos-conocimiento" class="scroll menu-transferimos-conocimiento">Transferimos conocimiento</a>
                    </li>
                    <li class="sub">
                        <a href="#impulsamos-conversaciones" class="scroll menu-impulsamos-conversaciones">Impulsamos conversaciones</a>
                    </li>
                    <li>
                        <a href="#agradecimientos" class="scroll menu-agradecimientos">Agradecimientos</a>
                    </li>
                </ul>
            </div>
        </header><!-- #masthead -->


        <div id="fullpage" class="site-content fullpage">