<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WP_Bootstrap_4
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
	<meta property="og:url" content="<?php echo get_page_link(); ?>" />
<meta property="og:type" content="article" />
<meta property="og:title" content="<?php echo the_title() ?>" />
<meta property="og:description" content="<?php
$yoast_meta = get_post_meta($post->ID, '_yoast_wpseo_metadesc', true);
if ($yoast_meta) { //check if the variable(with meta value) isn't empty
    echo $yoast_meta;
}
?>" >
	<meta property="og:image" content="https://bvro.mx/wp-content/uploads/2019/03/1.jpg" />
	<meta property="og:image:secure_url" content="https://bvro.mx/wp-content/uploads/2019/03/1.jpg" />
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-title" content="<?php bloginfo( 'name' ); ?> - <?php bloginfo( 'description' ); ?>">
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
    <?php wp_head(); ?>
    <link rel="icon" href="<?php echo get_template_directory_uri(); ?>/favicon.png">
    <script>window.pipedriveLeadboosterConfig = {base: 'leadbooster-chat.pipedrive.com',companyId: 
6723222,playbookUuid: '11f11a7c-e8b4-44ca-a83b-8ddb9ce5b640',version: 2};</script><script src="https://leadbooster-chat.pipedrive.com/assets/loader.js" async></script>

<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-5V47GBX');</script>
<!-- End Google Tag Manager -->

<script> (function(ss,ex){ window.ldfdr=window.ldfdr||function(){(ldfdr._q=ldfdr._q||[]).push([].slice.call(arguments));}; (function(d,s){ fs=d.getElementsByTagName(s)[0]; function ce(src){ var cs=d.createElement(s); cs.src=src; cs.async=1; fs.parentNode.insertBefore(cs,fs); }; ce('https://sc.lfeeder.com/lftracker_v1_'+ss+(ex?'_'+ex:'')+'.js'); })(document,'script'); })('JMvZ8gbovn5a2pOd'); </script>

</head>

<body <?php body_class(); ?>>
    <!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-5V47GBX"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->


<div class="container-fluid">
    <header>
        <div class="logo" align="center">
            <a class="nav-link-custom" href="<?php echo site_url(); ?>/#home">
                <img src="<?php echo site_url(); ?>/wp-content/uploads/2019/02/logo.png" class="img-responsive">
            </a>
        </div>
    </header>
    <div class="main-header">
        <div class="mobile-toggle">
            <div class="button_container" id="toggle">
                <span class="top"></span>
                <span class="bottom"></span>
            </div>
        </div>
        <div class="mobile-menu">
            <div class="Menu">
              <ul class="Menu-list" data-offset="8">
                <li class="Menu-list-item" data-offset="4">
                  <a class="nav-link-custom" href="<?php echo site_url(); ?>/#marketing-digital">
                    MARKETING DIGITAL
                    <span class="Mask"><span>MARKETING DIGITAL</span></span>
                    <span class="Mask"><span>MARKETING DIGITAL</span></span>
                  </a>
                </li>
                <li class="Menu-list-item" data-offset="4">
                  <a class="nav-link-custom" href="<?php echo site_url(); ?>/#desarrollo-web">
                    DESARROLLO WEB
                    <span class="Mask"><span>DESARROLLO WEB</span></span>
                    <span class="Mask"><span>DESARROLLO WEB</span></span>
                  </a>
                </li>
                <li class="Menu-list-item" data-offset="4">
                  <a class="nav-link-custom" href="<?php echo site_url(); ?>/#branding">
                    BRANDING
                    <span class="Mask"><span>BRANDING</span></span>
                    <span class="Mask"><span>BRANDING</span></span>
                  </a>
                </li>
                <li class="Menu-list-item" data-offset="4">
                  <a class="nav-link-custom" href="<?php echo site_url(); ?>/#publicidad">
                    PUBLICIDAD
                    <span class="Mask"><span>PUBLICIDAD</span></span>
                    <span class="Mask"><span>PUBLICIDAD</span></span>
                  </a>
                </li>
                <li class="Menu-list-item" data-offset="4">
                  <a class="nav-link-custom" href="<?php echo site_url(); ?>/#foto-video">
                    FOTO Y VIDEO
                    <span class="Mask"><span>FOTO Y VIDEO</span></span>
                    <span class="Mask"><span>FOTO Y VIDEO</span></span>
                  </a>
                </li>
                <li class="Menu-list-item" data-offset="4">
                    <a href="#" class="_3d-flip-book  fb3d-link-lightbox-mode nav-link-custom" data-id="206" data-mode="link-lightbox" data-title="false" data-template="short-white-book-view" data-lightbox="dark" data-urlparam="fb3d-page" data-page-n="0" data-pdf="" data-tax="null" data-thumbnail="" data-cols="3" id="close-menu">
                        PORTAFOLIO
                    <span class="Mask"><span>PORTAFOLIO</span></span>
                    <span class="Mask"><span>PORTAFOLIO</span></span>
                  </a>
                </li>
				  <li class="Menu-list-item" data-offset="4">
                    <a href="https://bvro.mx/blog/" class="_3d-flip-book  fb3d-link-lightbox-mode nav-link-custom" data-id="206" data-mode="link-lightbox" data-title="false" data-template="short-white-book-view" data-lightbox="dark" data-urlparam="fb3d-page" data-page-n="0" data-pdf="" data-tax="null" data-thumbnail="" data-cols="3" id="close-menu">
                        Blog
                    <span class="Mask"><span>Blog</span></span>
                    <span class="Mask"><span>Blog</span></span>
                  </a>
                </li>
              </ul>
            </div>
        </div>
    </div>