<?php
/**
 * Theme functions and definitions
 *
 * @package HelloElementor
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define( 'HELLO_ELEMENTOR_VERSION', '2.5.0' );

if ( ! isset( $content_width ) ) {
	$content_width = 800; // Pixels.
}

if ( ! function_exists( 'hello_elementor_setup' ) ) {
	/**
	 * Set up theme support.
	 *
	 * @return void
	 */
	function hello_elementor_setup() {
		if ( is_admin() ) {
			hello_maybe_update_theme_version_in_db();
		}

		$hook_result = apply_filters_deprecated( 'elementor_hello_theme_load_textdomain', [ true ], '2.0', 'hello_elementor_load_textdomain' );
		if ( apply_filters( 'hello_elementor_load_textdomain', $hook_result ) ) {
			load_theme_textdomain( 'hello-elementor', get_template_directory() . '/languages' );
		}

		$hook_result = apply_filters_deprecated( 'elementor_hello_theme_register_menus', [ true ], '2.0', 'hello_elementor_register_menus' );
		if ( apply_filters( 'hello_elementor_register_menus', $hook_result ) ) {
			register_nav_menus( [ 'menu-1' => __( 'Header', 'hello-elementor' ) ] );
			register_nav_menus( [ 'menu-2' => __( 'Footer', 'hello-elementor' ) ] );
		}

		$hook_result = apply_filters_deprecated( 'elementor_hello_theme_add_theme_support', [ true ], '2.0', 'hello_elementor_add_theme_support' );
		if ( apply_filters( 'hello_elementor_add_theme_support', $hook_result ) ) {
			add_theme_support( 'post-thumbnails' );
			add_theme_support( 'automatic-feed-links' );
			add_theme_support( 'title-tag' );
			add_theme_support(
				'html5',
				[
					'search-form',
					'comment-form',
					'comment-list',
					'gallery',
					'caption',
				]
			);
			add_theme_support(
				'custom-logo',
				[
					'height'      => 100,
					'width'       => 350,
					'flex-height' => true,
					'flex-width'  => true,
				]
			);

			/*
			 * Editor Style.
			 */
			add_editor_style( 'classic-editor.css' );

			/*
			 * Gutenberg wide images.
			 */
			add_theme_support( 'align-wide' );

			/*
			 * WooCommerce.
			 */
			$hook_result = apply_filters_deprecated( 'elementor_hello_theme_add_woocommerce_support', [ true ], '2.0', 'hello_elementor_add_woocommerce_support' );
			if ( apply_filters( 'hello_elementor_add_woocommerce_support', $hook_result ) ) {
				// WooCommerce in general.
				add_theme_support( 'woocommerce' );
				// Enabling WooCommerce product gallery features (are off by default since WC 3.0.0).
				// zoom.
				add_theme_support( 'wc-product-gallery-zoom' );
				// lightbox.
				add_theme_support( 'wc-product-gallery-lightbox' );
				// swipe.
				add_theme_support( 'wc-product-gallery-slider' );
			}
		}
	}
}
add_action( 'after_setup_theme', 'hello_elementor_setup' );

function hello_maybe_update_theme_version_in_db() {
	$theme_version_option_name = 'hello_theme_version';
	// The theme version saved in the database.
	$hello_theme_db_version = get_option( $theme_version_option_name );

	// If the 'hello_theme_version' option does not exist in the DB, or the version needs to be updated, do the update.
	if ( ! $hello_theme_db_version || version_compare( $hello_theme_db_version, HELLO_ELEMENTOR_VERSION, '<' ) ) {
		update_option( $theme_version_option_name, HELLO_ELEMENTOR_VERSION );
	}
}

if ( ! function_exists( 'hello_elementor_scripts_styles' ) ) {
	/**
	 * Theme Scripts & Styles.
	 *
	 * @return void
	 */
	function hello_elementor_scripts_styles() {
		$enqueue_basic_style = apply_filters_deprecated( 'elementor_hello_theme_enqueue_style', [ true ], '2.0', 'hello_elementor_enqueue_style' );
		$min_suffix          = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

		if ( apply_filters( 'hello_elementor_enqueue_style', $enqueue_basic_style ) ) {
			wp_enqueue_style(
				'hello-elementor',
				get_template_directory_uri() . '/style' . $min_suffix . '.css',
				[],
				HELLO_ELEMENTOR_VERSION
			);
		}

		if ( apply_filters( 'hello_elementor_enqueue_theme_style', true ) ) {
			wp_enqueue_style(
				'hello-elementor-theme-style',
				get_template_directory_uri() . '/theme' . $min_suffix . '.css',
				[],
				HELLO_ELEMENTOR_VERSION
			);
		}
	}
}
add_action( 'wp_enqueue_scripts', 'hello_elementor_scripts_styles' );

if ( ! function_exists( 'hello_elementor_register_elementor_locations' ) ) {
	/**
	 * Register Elementor Locations.
	 *
	 * @param ElementorPro\Modules\ThemeBuilder\Classes\Locations_Manager $elementor_theme_manager theme manager.
	 *
	 * @return void
	 */
	function hello_elementor_register_elementor_locations( $elementor_theme_manager ) {
		$hook_result = apply_filters_deprecated( 'elementor_hello_theme_register_elementor_locations', [ true ], '2.0', 'hello_elementor_register_elementor_locations' );
		if ( apply_filters( 'hello_elementor_register_elementor_locations', $hook_result ) ) {
			$elementor_theme_manager->register_all_core_location();
		}
	}
}
add_action( 'elementor/theme/register_locations', 'hello_elementor_register_elementor_locations' );

if ( ! function_exists( 'hello_elementor_content_width' ) ) {
	/**
	 * Set default content width.
	 *
	 * @return void
	 */
	function hello_elementor_content_width() {
		$GLOBALS['content_width'] = apply_filters( 'hello_elementor_content_width', 800 );
	}
}
add_action( 'after_setup_theme', 'hello_elementor_content_width', 0 );

if ( is_admin() ) {
	require get_template_directory() . '/includes/admin-functions.php';
}

/**
 * If Elementor is installed and active, we can load the Elementor-specific Settings & Features
*/

// Allow active/inactive via the Experiments
require get_template_directory() . '/includes/elementor-functions.php';

/**
 * Include customizer registration functions
*/
function hello_register_customizer_functions() {
	if ( hello_header_footer_experiment_active() && is_customize_preview() ) {
		require get_template_directory() . '/includes/customizer-functions.php';
	}
}
add_action( 'init', 'hello_register_customizer_functions' );

if ( ! function_exists( 'hello_elementor_check_hide_title' ) ) {
	/**
	 * Check hide title.
	 *
	 * @param bool $val default value.
	 *
	 * @return bool
	 */
	function hello_elementor_check_hide_title( $val ) {
		if ( defined( 'ELEMENTOR_VERSION' ) ) {
			$current_doc = Elementor\Plugin::instance()->documents->get( get_the_ID() );
			if ( $current_doc && 'yes' === $current_doc->get_settings( 'hide_title' ) ) {
				$val = false;
			}
		}
		return $val;
	}
}
add_filter( 'hello_elementor_page_title', 'hello_elementor_check_hide_title' );

/**
 * Wrapper function to deal with backwards compatibility.
 */
if ( ! function_exists( 'hello_elementor_body_open' ) ) {
	function hello_elementor_body_open() {
		if ( function_exists( 'wp_body_open' ) ) {
			wp_body_open();
		} else {
			do_action( 'wp_body_open' );
		}
	}
}


function formClientes(){
	?>
	
<div id="generador-url">
	

	<form id="form-cliente" class="" method="post" novalidate="novalidate" enctype="multipart/form-data">
		<div class="input-wrapper">
			<input type="hidden" id="id_token" name="idtoken" value="">
			<label for="cliente">Ingresar nombre del cliente para generar la URL</label>
			<input id="cliente_nombre" name="cliente" type="text" placeholder="Nombre del cliente" required>
		</div>
		<div class="btn-wrapper">
			<input class="elementor-button" type="submit" value="Generar URL" >
		</div>
	</form>
	<div id="registrado" class="alert alert-success">
		<div class="msg-wrapper">
			
		
			<span class="texto">Se ha creado el registro con éxito. URL:</span> <span id="url"></span>
		<button id="copiar" class="elementor-button">
			
			Copiar url
			<span id="copiado">Copiado al portapapeles</span>
		</button>
		</div>
	</div>

	<div id="error" class="alert alert-error">
		Ha ocurrido un error. Intenta de nuevo.
	</div>
</div>
	<style>
		#generador-url, #generador-url * {
			font-family:"Poppins" !important;
		}
		.msg-wrapper {
		  display: flex;
		  flex-direction: column;
		  justify-content: center;
		  align-content: center;
		  align-items: center;
			gap: 15px;
		}
		#form-cliente {
			display: flex;
			flex-direction: row;
			justify-content: space-between;
			align-items: end;
		}
		.input-wrapper {
			width:75%;
		}
		.btn-wrapper {
			width: 20%;
		}
		.btn-wrapper .elementor-button {
			background: #0aab95;
			border: none;
			border-radius: 50px;
		}
		.alert {
			display: none;
			margin-top: 15px;
		}
		.alert-success {
			background:#0aab41;
			color: #fff;
			padding: 2em;
			text-align:center;
		}
		.alert-error {
			background:#ab0a21;
			color: #fff;
			padding: 2em;
			text-align:center;
		}
		#copiar {
			position: relative;
			background: #fff;
			font-size: 12px;
			text-transform: uppercase;
			color: #000;
			border: none;
			border-radius: 50px;
			box-shadow: 0 3px 6px rgba(0,0,0,0.16), 0 2px 4px rgba(0,0,0,0.23);
			display: inline-flex;
			max-width: 150px;
			text-align: center;
			justify-content: center;
		}
		#copiado {
			display: none;
			position: absolute;
			font-size: 10px;
			background: #fff;
			color: #000;
			padding: 2px 5px;
			border-radius: 2px;
			box-shadow: 0 3px 6px rgba(0,0,0,0.16), 0 2px 4px rgba(0,0,0,0.23);
			bottom: -20px;
			left: 50%;
			transform: translateX(-50%);
		}
		#url {
			font-size: 14px;
		}
		
	</style>

<script>
		jQuery( document ).ready( function($){
		
			
			$("#copiar").click( function(e){
				e.preventDefault();
			  var $temp = $("<input>");
			  $("body").append($temp);
			  $temp.val($('#url').html()).select();
			  document.execCommand("copy");
			  $temp.remove();
				$("#copiado").slideToggle('fast').delay(2000).slideToggle('fast');
				
			});
		// program to generate random strings
		// declare all characters
		const characters ='ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';

		function generateString(length) {
			let result = '';
			const charactersLength = characters.length;
			for ( let i = 0; i < length; i++ ) {
				result += characters.charAt(Math.floor(Math.random() * charactersLength));
			}

			return result;
		}

		var token = generateString(16);
			
			$("#id_token").val(token);
			var tkn = $("#id_token").val();
			
			$("input[type=submit]").click(function(e){
				
				//$( "#cliente_nombre, #form-cliente input" ).prop( "disabled", true );
			e.preventDefault();
				if($("#cliente_nombre").val() == ""){
					alert("Nombre del cliente es obligatorio");
				} else {
				var boton = $(this);
				var formID = $(this).closest("form").attr('id');    
				console.log (formID);

				var form = $('#'+formID);

				if (form.valid()) {
					var datos = form.serialize();	
					console.log(datos);

					boton.css( "cursor", "progress" );
					boton.attr('disabled','disabled');

					//send form
					$.ajax({
						type: "POST",
						url: 'https://bvro.mx/encuesta-de-satisfaccion/wp-content/themes/hello-elementor/assets/forma.php',
						data: datos,
						success: function(result){
							//mostrar modal de agradecimiento
							//$("#modalregistro").modal();
							
							//re-habilitar botones y limpiar formulario
							boton.css( "cursor", "pointer" );
							boton.removeAttr('disabled');
							$('#'+formID)[0].reset();

							var datos = JSON.parse(result);

							if (datos == "Data sent") {								
								$("#form-cliente").hide();

								$("#url").html('https://bvro.mx/encuesta-de-satisfaccion?token='+tkn);
								$("#registrado").slideToggle('fast').delay(12000).slideToggle();
								setTimeout(function(){
									token = "";
									location.reload();
								},6000)
							} else {
																$("#form-cliente").hide();

								$("#error").slideToggle('fast').delay(5000).slideToggle();
								console.log("Error: ", datos);
								setTimeout(function(){
									token = "";
									location.reload();
								},6000)
							}
						},
						error: function(jqXHR, textStatus, errorThrown){
							console.log(errorThrown);
						}
					});

				} else {
					console.log("forma invalida");
				}
				}
			});
			
			
		});
	</script>
	<?
}

add_shortcode('form-clientes', 'formClientes');

function getUsersList(){
	global $wpdb;
	
	$clientes = $wpdb->get_results( "SELECT * FROM {$wpdb->prefix}clientes ", OBJECT );
	?>

	
	<section class="table-wrapper">
		<div class="container">
			<div class="row">
				<div class="col-md-12 content-table">
					<table id="users-table" class="table table-usuarios activos active">
						<thead>
							<tr>
						  		<th scope="col">Nombre</th>
						  		<th scope="col">Token</th>
								<th scope="col">URL</th>
						  		
								
							</tr>
					  	</thead>
						<tbody>
							<?
								foreach( $clientes as $cliente ){
																	
							
									
									?>
									<tr>
										<td><?php echo $cliente->cliente ?></td>
										<td><?php echo $cliente->idtoken ?></td>
										<td><?php echo $cliente->url ?></td>
										
									</tr>
									<?
								}
							?>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</section>
		<style>
			.table-wrapper * {
				font-family: "Poppins";
			}
		</style>
<script>
	jQuery(document).ready( function($){
		// DataTables
	$('#users-table').DataTable({
		"order": [[ 0, "asc" ]]
	});
	})
</script>

<?
}
add_shortcode('get-users-list','getUsersList');

function getCustomerName(){
    global $wpdb, $table_prefix;
	
	if(isset($_GET['token'])){
$user_ID=$_GET['token'];
}
	
	/*	$value = $wpdb->get_results($wpdb->prepare('SELECT cliente FROM wp_clientes WHERE idtoken = '.$user_ID));
		file_put_contents('dblog.txt', $value, FILE_APPEND | LOCK_EX);*/
	

$servername = "localhost";
$username = "encuestas";
$password = "optiplex#2022++";
$dbname = "bvro_encuestas";

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);
// Check connection
if ($conn->connect_error) {
  die("Connection failed: " . $conn->connect_error);
}

$sql = 'SELECT cliente FROM wp_clientes WHERE idtoken="'.$user_ID.'";';
$result = $conn->query($sql);

if ($result->num_rows > 0) {
  // output data of each row
  while($row = $result->fetch_assoc()) {
    $value = $row['cliente'];
  }
} else {
	$value = 0;
  return;
}

   ?>
	<script>
		jQuery(document).ready( function($){
			var nombre = "<?php echo $value ?>";
			$('input[name="cliente"]').val(nombre);
		})
	</script>
<?php
$conn->close();
}
add_shortcode('customer-name', 'getCustomerName');
