<?php
/**
 * Theme functions and definitions
 *
 * @package HelloElementor
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define( 'HELLO_ELEMENTOR_VERSION', '2.2.0' );

if ( ! isset( $content_width ) ) {
	$content_width = 800; // Pixels.
}

if ( ! function_exists( 'hello_elementor_setup' ) ) {
	/**
	 * Set up theme support.
	 *
	 * @return void
	 */
	function hello_elementor_setup() {
		$hook_result = apply_filters_deprecated( 'elementor_hello_theme_load_textdomain', [ true ], '2.0', 'hello_elementor_load_textdomain' );
		if ( apply_filters( 'hello_elementor_load_textdomain', $hook_result ) ) {
			load_theme_textdomain( 'hello-elementor', get_template_directory() . '/languages' );
		}

		$hook_result = apply_filters_deprecated( 'elementor_hello_theme_register_menus', [ true ], '2.0', 'hello_elementor_register_menus' );
		if ( apply_filters( 'hello_elementor_register_menus', $hook_result ) ) {
			register_nav_menus( array( 'menu-1' => __( 'Primary', 'hello-elementor' ) ) );
		}

		$hook_result = apply_filters_deprecated( 'elementor_hello_theme_add_theme_support', [ true ], '2.0', 'hello_elementor_add_theme_support' );
		if ( apply_filters( 'hello_elementor_add_theme_support', $hook_result ) ) {
			add_theme_support( 'post-thumbnails' );
			add_theme_support( 'automatic-feed-links' );
			add_theme_support( 'title-tag' );
			add_theme_support(
				'html5',
				array(
					'search-form',
					'comment-form',
					'comment-list',
					'gallery',
					'caption',
				)
			);
			add_theme_support(
				'custom-logo',
				array(
					'height'      => 100,
					'width'       => 350,
					'flex-height' => true,
					'flex-width'  => true,
				)
			);

			/*
			 * Editor Style.
			 */
			add_editor_style( 'editor-style.css' );

			/*
			 * WooCommerce.
			 */
			$hook_result = apply_filters_deprecated( 'elementor_hello_theme_add_woocommerce_support', [ true ], '2.0', 'hello_elementor_add_woocommerce_support' );
			if ( apply_filters( 'hello_elementor_add_woocommerce_support', $hook_result ) ) {
				// WooCommerce in general.
				add_theme_support( 'woocommerce' );
				// Enabling WooCommerce product gallery features (are off by default since WC 3.0.0).
				// zoom.
				add_theme_support( 'wc-product-gallery-zoom' );
				// lightbox.
				add_theme_support( 'wc-product-gallery-lightbox' );
				// swipe.
				add_theme_support( 'wc-product-gallery-slider' );
			}
		}
	}
}
add_action( 'after_setup_theme', 'hello_elementor_setup' );

if ( ! function_exists( 'hello_elementor_scripts_styles' ) ) {
	/**
	 * Theme Scripts & Styles.
	 *
	 * @return void
	 */
	function hello_elementor_scripts_styles() {
		$enqueue_basic_style = apply_filters_deprecated( 'elementor_hello_theme_enqueue_style', [ true ], '2.0', 'hello_elementor_enqueue_style' );
		$min_suffix          = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

		if ( apply_filters( 'hello_elementor_enqueue_style', $enqueue_basic_style ) ) {
			wp_enqueue_style(
				'hello-elementor',
				get_template_directory_uri() . '/style' . $min_suffix . '.css',
				[],
				HELLO_ELEMENTOR_VERSION
			);
		}

		if ( apply_filters( 'hello_elementor_enqueue_theme_style', true ) ) {
			wp_enqueue_style(
				'hello-elementor-theme-style',
				get_template_directory_uri() . '/theme' . $min_suffix . '.css',
				[],
				HELLO_ELEMENTOR_VERSION
			);
		}
	}
}
add_action( 'wp_enqueue_scripts', 'hello_elementor_scripts_styles' );

if ( ! function_exists( 'hello_elementor_register_elementor_locations' ) ) {
	/**
	 * Register Elementor Locations.
	 *
	 * @param ElementorPro\Modules\ThemeBuilder\Classes\Locations_Manager $elementor_theme_manager theme manager.
	 *
	 * @return void
	 */
	function hello_elementor_register_elementor_locations( $elementor_theme_manager ) {
		$hook_result = apply_filters_deprecated( 'elementor_hello_theme_register_elementor_locations', [ true ], '2.0', 'hello_elementor_register_elementor_locations' );
		if ( apply_filters( 'hello_elementor_register_elementor_locations', $hook_result ) ) {
			$elementor_theme_manager->register_all_core_location();
		}
	}
}
add_action( 'elementor/theme/register_locations', 'hello_elementor_register_elementor_locations' );

if ( ! function_exists( 'hello_elementor_content_width' ) ) {
	/**
	 * Set default content width.
	 *
	 * @return void
	 */
	function hello_elementor_content_width() {
		$GLOBALS['content_width'] = apply_filters( 'hello_elementor_content_width', 800 );
	}
}
add_action( 'after_setup_theme', 'hello_elementor_content_width', 0 );

if ( is_admin() ) {
	require get_template_directory() . '/includes/admin-functions.php';
}

if ( ! function_exists( 'hello_elementor_check_hide_title' ) ) {
	/**
	 * Check hide title.
	 *
	 * @param bool $val default value.
	 *
	 * @return bool
	 */
	function hello_elementor_check_hide_title( $val ) {
		if ( defined( 'ELEMENTOR_VERSION' ) ) {
			$current_doc = \Elementor\Plugin::instance()->documents->get( get_the_ID() );
			if ( $current_doc && 'yes' === $current_doc->get_settings( 'hide_title' ) ) {
				$val = false;
			}
		}
		return $val;
	}
}
add_filter( 'hello_elementor_page_title', 'hello_elementor_check_hide_title' );

/**
 * Wrapper function to deal with backwards compatibility.
 */
if ( ! function_exists( 'hello_elementor_body_open' ) ) {
	function hello_elementor_body_open() {
		if ( function_exists( 'wp_body_open' ) ) {
			wp_body_open();
		} else {
			do_action( 'wp_body_open' );
		}
	}
}



function display_portafolio($atts) {
	$args = array(
	    'type'                     => 'portafolios',
	    'child_of'                 => 0,
	    'parent'                   => '',
	    'orderby'                  => 'name',
	    'order'                    => 'DESC',
	    'hide_empty'               => 1,
	    'hierarchical'             => 0,
	    'exclude'                  => '',
	    'include'                  => '',
	    'number'                   => '',
	    'taxonomy'                 => 'cat',
	    'pad_counts'               => false 
	);

	$categories = get_categories( $args );

	extract( shortcode_atts( array (
        'categoria' => ''
    ), $atts ) );

	$paged = (get_query_var('paged')) ? absint(get_query_var('paged')) : 1;
	$query_args = array(
	'post_type' => 'portafolios',
	'post_status' => 'publish',
	'order' => 'ASC',
	'orderby' => 'date',
	'posts_per_page' => '12',
	'category_name' => $categoria,
	'paged' => $paged,
	);


// The Query
$the_query = new WP_Query( $query_args );

?>
<div class="pop-portafolio-container">
	<div class="close-pop-button">
		<img src="<?php echo get_site_url(); ?>/wp-content/uploads/2022/11/interior-close.png">
	</div>
	<div class="pop-portafolio">
	<?php

		// The Loop
		if ( $the_query->have_posts() ) {
			while ( $the_query->have_posts() ) {
				$the_query->the_post();

				?>			
					<div class="pop-portafolio-content">
						<div class="txt-general">
							<?php
								if (get_field('titulo')) {
									echo the_field('titulo');
								} else {

								}
							?>
						</div>
						<div class="row-gallery">
							<?php
								if (get_field('galeria_de_imagenes')) {
									echo the_field('galeria_de_imagenes');
								} else {

								}
							?>
						</div>
						<div class="btn-general">
							<?php
								if (get_field('url_del_sitio')) {
									?>
									<a href="<?php echo the_field('url_del_sitio'); ?>" target="_blank">Ver Más</a>
									<?php
								} else {

								}
							?>
						</div>
					</div>
				<?php
			}
			wp_reset_postdata();
		} else {
			// no posts found
		}
	?>
	</div>
</div>
<?php

?>
<div class="row-portafolio">

	<?php

		// The Loop
		if ( $the_query->have_posts() ) {
			while ( $the_query->have_posts() ) {
				$the_query->the_post();

				?>			
					<div class="col-portafolio" data-size-img="<?php echo get_field('imagen_vertical_completo');?>">
						<div class="col-portafolio-inner">
							<?php echo get_the_post_thumbnail();?>
							<div class="info-extra">
								<h1><?php echo get_the_title(); ?></h1>
								<h6><?php echo get_field('categoria');?></h6>
							</div>
						</div>
					</div>
				<?php
			}
			?>
			<?php
			wp_reset_postdata();
		} else {
			?>			
				<div class="div-sin-proyectos txt-general btn-general ">
					<h4>Pagina sin proyectos</h4>
					<a href="https://bvro.mx/portafolio/">Regresar</a>
				</div>
			<?php
		}
	?>


</div>
<nav class="pagination">
    <?php
		$big = 999999999; 
		 
		echo paginate_links( array(
		    'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
		    'format' => '?paged=%#%',
		    'current' => max( 1, get_query_var('paged') ),
		    'total' => $the_query->max_num_pages,
		    'prev_text' => '<',
		    'next_text' => '>'
		) );
	?>
</nav>
<?php



}

add_shortcode('shorcode_portafolio', 'display_portafolio');



// define the wpcf7_before_send_mail callback 
function connect_to_profet( $contact_form ) {
	$form_id = $_POST['_wpcf7'];
	//echo "Form ID: ".$form_id;
	if ($form_id == 37){ // ID DEL FORMULARIO DE CF7
		//SEND TO PROFET
		$url = 'https://profet.azurewebsites.net/api/leadsapi';
		//$url_2 = 'http://nuevoprofet.azurewebsites.net';
		// what post fields?
		$fields = array(
			'campaignId' => 181,
			'name' => $_POST["nombre"],
			'email'=> $_POST["correo"],
			'phone'=> $_POST["telefono"],
			'messageSent' => $_POST['mensaje'],
			'prospectSource' => "Bvro Site"
		);
		 // build the urlencoded data
      $postvars = http_build_query($fields);
      // open connection
      $ch = curl_init();
      // set the url, number of POST vars, POST data
      curl_setopt($ch, CURLOPT_URL, $url);
      curl_setopt($ch, CURLOPT_POST, count($fields));
      curl_setopt($ch, CURLOPT_POSTFIELDS, $postvars);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      // execute post
      $result = curl_exec($ch);
      // close connection
      curl_close($ch);

		//PROFET
	} else  {
		return;
	}
};
// add the action
add_action( 'wpcf7_before_send_mail', 'connect_to_profet', 10, 1 );
?>